<?php
session_start();

if ($_SESSION["CURRENT_USER"] == "") {
    exit("Please Login Again !!!");
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <title>Customer Master Report</title>
        <style>
            body{
                font-family:Arial, Helvetica, sans-serif;
                font-size:14px;
            }
            table
            {
                border-collapse:collapse;

            }
            table, td, th
            {

                font-family:Arial, Helvetica, sans-serif;
                padding:5px;
                margin-bottom:25px;
            }
            th
            {
                font-weight:bold;
                font-size:12px;

            }
            td
            {
                font-size:12px;

            }
        </style>
        <style type="text/css">
            <!--
            .style1 {
                color: #0000FF;
                font-weight: bold;
                font-size: 24px;
            }
            -->

            <!--
            .red {
                color: #FF0000;
                font-weight: bold;
                font-size: 12px;
            }
            -->
        </style>
    </head>

    <body>
  <div class="container">   
<?php
require_once("config.inc.php");
require_once("DBConnector.php");
$db = new DBConnector();

// Safely retrieve GET parameters with default fallback
$from = isset($_GET['from']) ? $_GET['from'] : '';
$to = isset($_GET['to']) ? $_GET['to'] : '';
$rep = isset($_GET['cmbrep']) ? $_GET['cmbrep'] : 'All';
?>

 
<div style='text-align: center; margin-bottom: 30px;'>
<h2>Cheque Collection Report</h2>
<p><strong>Date Range:</strong> <?php echo  $from . " to " . $to  ?></p>
<p><strong>Sales Rep:</strong>  <?php echo  htmlspecialchars(($rep === "All" ? "All Representatives" : $rep))  ?></p>
</div>

<?php
// Optional: Validate or sanitize the inputs here if needed
// Example: check date format (basic)
if (!preg_match("/^\d{4}-\d{2}-\d{2}$/", $from) || !preg_match("/^\d{4}-\d{2}-\d{2}$/", $to)) {
    exit("Invalid date format. Use YYYY-MM-DD.");
}
 

if ($rep == 'All') {
    // Fetch all active sales reps
    $repsql = "SELECT REPCODE, Name FROM s_salrep WHERE cancel = '1' ORDER BY REPCODE";
    $represult = $db->RunQuery($repsql);

    while ($reprow = mysql_fetch_array($represult)) {
        $repcode = $reprow['REPCODE'];
        $repname = $reprow['Name'];

        echo "<h3 style='margin-top:30px;'>Rep: $repcode - $repname</h3>";

        // Fetch cheque collections for this rep
        $sql = "SELECT * FROM cheque_collection 
                WHERE ref = '$repcode' 
                  AND created_at >= '$from' 
                  AND created_at <= '$to' 
                ORDER BY created_at DESC";

        $result = $db->RunQuery($sql);

        echo "<table border='1' cellpadding='5' cellspacing='0' width='100%'>";
        echo "<tr style='background:#f0f0f0;'>
                <th>Date</th>
                <th>Customer Code</th>
                <th>Customer Name</th>
                <th>Cheque No</th>
                <th>Amount</th>
                <th>Invoice No</th>
                <th>Cheque Date</th>
                <th>Cheque Realization Date </th>
                <th>Bank</th>
              </tr>";

        $hasData = false;
        while ($row = mysql_fetch_array($result)) {
            $hasData = true;
            echo "<tr>
                    <td>{$row['created_at']}</td>
                    <td>{$row['customer_code']}</td>
                    <td>{$row['customer_name']}</td>
                    <td>{$row['cheque_number']}</td>
                    <td align='right'>".number_format($row['amount'], 2)."</td>
                    <td>{$row['invoice_number']}</td>
                    <td>{$row['cheque_date']}</td>
                    <td>{$row['cheque_realization_date']}</td>
                    <td>{$row['bank_name']}</td>
                  </tr>";
        }

        if (!$hasData) {
            echo "<tr><td colspan='8' align='center'>No records found for this rep in selected date range.</td></tr>";
        }

        echo "</table>";
    }
} else {
    // Fetch selected rep's name
    $namesql = "SELECT Name FROM s_salrep WHERE REPCODE = '$rep'";
    $nameresult = $db->RunQuery($namesql);
    $repname = '';
    if ($namerow = mysql_fetch_array($nameresult)) {
        $repname = $namerow['Name'];
    }

    echo "<h3 style='margin-top:30px;'>Rep: $rep - $repname</h3>";

    $sql = "SELECT * FROM cheque_collection 
            WHERE ref = '$rep' 
              AND created_at >= '$from' 
              AND created_at <= '$to' 
            ORDER BY created_at DESC";
            
    $result = $db->RunQuery($sql);

    echo "<table border='1' cellpadding='5' cellspacing='0' width='100%'>";
    echo "<tr style='background:#f0f0f0;'>
            <th>Date</th>
            <th>Customer Code</th>
            <th>Customer Name</th>
            <th>Cheque No</th>
            <th>Amount</th>
            <th>Invoice No</th>
            <th>Cheque Date</th>
             <th>Cheque Realization Date </th>
            <th>Bank</th>
          </tr>";

    $hasData = false;
    while ($row = mysql_fetch_array($result)) {
        $hasData = true;
        echo "<tr>
                <td>{$row['created_at']}</td>
                <td>{$row['customer_code']}</td>
                <td>{$row['customer_name']}</td>
                <td>{$row['cheque_number']}</td>
                <td align='right'>".number_format($row['amount'], 2)."</td>
                <td>{$row['invoice_number']}</td>
                <td>{$row['cheque_date']}</td>
                 <td>{$row['cheque_realization_date']}</td>
                <td>{$row['bank_name']}</td>
              </tr>";
    }

    if (!$hasData) {
        echo "<tr><td colspan='8' align='center'>No records found for selected rep.</td></tr>";
    }

    echo "</table>";
}
       
?>
</div> 
    </body>
</html>



 
