<?php
	include('home_dashboard_data.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
  
  <style>

    .container {
      max-width: 1400px;
    }
    .dashboard-card {
      background: white;
      border-radius: 16px;
      padding: 2rem;
      border: 1px solid #e5e7eb;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
      height: 100%;
      transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
      cursor: pointer;
      position: relative;
      overflow: hidden;
    }

    .dashboard-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 3px;
      background: linear-gradient(90deg, transparent, currentColor, transparent);
      opacity: 0;
      transition: opacity 0.3s ease;
    }

    .dashboard-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
      border-color: #d1d5db;
    }

    .dashboard-card:hover::before {
      opacity: 1;
    }

    .icon-box {
      width: 56px;
      height: 56px;
      border-radius: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 24px;
      color: white;
      margin-bottom: 1.5rem;
      transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
      position: relative;
      overflow: hidden;
    }

    .icon-box::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: linear-gradient(45deg, rgba(255,255,255,0.2), rgba(255,255,255,0.1));
      opacity: 0;
      transition: opacity 0.3s ease;
    }

    .dashboard-card:hover .icon-box {
      transform: scale(1.15) rotate(5deg);
    }

    .dashboard-card:hover .icon-box::before {
      opacity: 1;
    }

    .revenue {
      color: #ef4444;
    }

    .revenue .icon-box {
      background: linear-gradient(135deg, #ef4444, #dc2626);
    }

    .orders {
      color: #10b981;
    }

    .orders .icon-box {
      background: linear-gradient(135deg, #10b981, #059669);
    }

    .outstanding {
      color: #f59e0b;
    }

    .outstanding .icon-box {
      background: linear-gradient(135deg, #f59e0b, #d97706);
    }

    .returns {
      color: #3b82f6;
    }

    .returns .icon-box {
      background: linear-gradient(135deg, #3b82f6, #2563eb);
    }

    .card-title {
      font-size: 0.875rem;
      font-weight: 600;
      color: #6b7280;
      margin-bottom: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .card-value {
      font-size: 1.65rem;
      font-weight: 800;
      color: #111827;
      margin-bottom: 0.75rem;
      line-height: 1.1;
      font-variant-numeric: tabular-nums;
    }

    .card-change {
      font-size: 0.875rem;
      font-weight: 600;
      padding: 0.25rem 0.75rem;
      border-radius: 20px;
      display: inline-block;
      transition: all 0.3s ease;
    }

    .card-change.positive {
      color: #059669;
      background: rgba(5, 150, 105, 0.1);
      border: 1px solid rgba(5, 150, 105, 0.2);
    }

    .card-change.negative {
      color: #dc2626;
      background: rgba(220, 38, 38, 0.1);
      border: 1px solid rgba(220, 38, 38, 0.2);
    }

    .chart-card {
      background: white;
      border-radius: 20px;
      border: 1px solid #e5e7eb;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
      transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
      margin-bottom: 2rem;
      overflow: hidden;
    }

    .chart-card:hover {
      transform: translateY(-4px);
      box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }

    .chart-card .card-body {
      padding: 2rem;
    }

    .chart-title {
      font-size: 1.5rem;
      font-weight: 700;
      color: #111827;
      margin-bottom: 1.5rem;
      position: relative;
      padding-left: 1rem;
    }

    .chart-title::before {
      content: '';
      position: absolute;
      left: 0;
      top: 50%;
      transform: translateY(-50%);
      width: 4px;
      height: 24px;
      background: linear-gradient(135deg, #6366f1, #8b5cf6);
      border-radius: 2px;
    }

    .form-select {
      border: 2px solid #e5e7eb;
      border-radius: 12px;
      padding: 0.75rem 1rem;
      font-weight: 500;
      background: white;
      transition: all 0.3s ease;
      box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }

    .form-select:focus {
      border-color: #6366f1;
      box-shadow: 0 0 0 4px rgba(99, 102, 241, 0.1);
      outline: none;
      transform: translateY(-1px);
    }

    .form-label {
      font-weight: 600;
      color: #374151;
      margin-bottom: 0.5rem;
    }

    .chart-container {
      position: relative;
      height: 400px;
      width: 100%;
      margin-top: 1.5rem;
      padding: 1rem;
      background: rgba(249, 250, 251, 0.5);
      border-radius: 12px;
    }

    .daily-chart-container {
      position: relative;
      height: 350px;
      width: 100%;
      margin-top: 1.5rem;
      padding: 1rem;
      background: rgba(249, 250, 251, 0.5);
      border-radius: 12px;
    }

    .year-selector {
      background: white;
      padding: 1rem 1.5rem;
      border-radius: 12px;
      border: 2px solid #e5e7eb;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
      transition: all 0.3s ease;
    }

    .year-selector:hover {
      border-color: #d1d5db;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }

    /* Enhanced responsive design */
    @media (max-width: 768px) {
      .dashboard-title {
        font-size: 2rem;
      }
      
      .card-value {
        font-size: 1.75rem;
      }
      
      .dashboard-card {
        padding: 1.5rem;
      }
      
      .icon-box {
        width: 48px;
        height: 48px;
        font-size: 20px;
      }

      .chart-container {
        height: 300px;
        padding: 0.75rem;
      }

      .daily-chart-container {
        height: 280px;
        padding: 0.75rem;
      }

      .chart-card .card-body {
        padding: 1.5rem;
      }

      .chart-title {
        font-size: 1.25rem;
      }
    }

    @media (max-width: 576px) {
      .dashboard-card {
        padding: 1.25rem;
      }
      
      .card-value {
        font-size: 1.5rem;
      }

      .chart-container {
        height: 250px;
        padding: 0.5rem;
      }

      .daily-chart-container {
        height: 240px;
        padding: 0.5rem;
      }

      .dashboard-header {
        padding: 1.5rem 0;
        margin-bottom: 2rem;
      }

      .chart-card .card-body {
        padding: 1.25rem;
      }

      .year-selector {
        padding: 0.75rem 1rem;
      }
    }

    /* Loading animation */
    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .dashboard-card {
      animation: fadeInUp 0.6s ease-out;
    }

    .dashboard-card:nth-child(1) { animation-delay: 0.1s; }
    .dashboard-card:nth-child(2) { animation-delay: 0.2s; }
    .dashboard-card:nth-child(3) { animation-delay: 0.3s; }
    .dashboard-card:nth-child(4) { animation-delay: 0.4s; }

    .chart-card {
      animation: fadeInUp 0.6s ease-out 0.5s both;
    }

    /* Subtle animations for values */
    .card-value {
      transition: all 0.3s ease;
    }

    .dashboard-card:hover .card-value {
      transform: scale(1.05);
    }

    /* Enhanced focus states for accessibility */
    .dashboard-card:focus-visible {
      outline: 3px solid #6366f1;
      outline-offset: 2px;
    }

    .form-select:focus-visible {
      outline: 3px solid #6366f1;
      outline-offset: 2px;
    }
  </style>
</head>
<body>
  <div class="container py-5">

    <div class="row g-4 mb-5">
      <div class="col-md-6 col-lg-3">
        <div class="dashboard-card revenue">
          <div class="icon-box">💰</div>
          <div class="card-title">Total Monthly Sale</div>
          <div class="card-value"><?php echo $totalCurrentFormatted; ?></div>
          <div class="card-change <?php echo $changeClassTotal; ?>"><?php echo $changeTotalFormatted; ?></div>
        </div>
      </div>

      <div class="col-md-6 col-lg-3">
        <div class="dashboard-card orders">
          <div class="icon-box">📦</div>
          <div class="card-title">Monthly Total Orders</div>
          <div class="card-value"><?php echo $ordersCurrentFormatted; ?></div>
          <div class="card-change <?php echo $changeClassOrders; ?>"><?php echo $changeOrdersFormatted; ?></div>
        </div>
      </div>

      <div class="col-md-6 col-lg-3">
          <div class="dashboard-card outstanding">
            <div class="icon-box">💰</div>
            <div class="card-title">Total Monthly Outstanding</div>
            <div class="card-value"><?php echo $outstandingCurrentFormatted; ?></div>
            <div class="card-change <?php echo $changeClassOutstanding; ?>"><?php echo $changeOutstandingFormatted; ?></div>
          </div>
     </div>
        
    <div class="col-md-6 col-lg-3">
      <div class="dashboard-card returns">
        <div class="icon-box">🔄</div>
        <div class="card-title">Monthly Total Returns</div>
        <div class="card-value"><?php echo $returnCurrentFormatted; ?></div>
        <div class="card-change <?php echo $changeClassReturn; ?>"><?php echo $changeReturnFormatted; ?></div>
      </div>
    </div>

    </div>

    <div class="row">
      <div class="col-12">
        <div class="chart-card">
          <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
              <h5 class="chart-title mb-0">Monthly Sales Overview</h5>
              <div class="year-selector">
                  <div class="d-flex align-items-center gap-3">
                    <label for="year" class="form-label mb-0">Year:</label>
                    <select name="year" id="year" class="form-select" onchange="updateChart(this.value)" style="width: auto; min-width: 100px;">
                      <?php
                        $currentYear = date('Y');
                        for ($y = $currentYear; $y >= $currentYear - 5; $y--) {
                            $selected = ($y == $selectedYear) ? 'selected' : '';
                            echo "<option value=\"$y\" $selected>$y</option>";
                        }
                      ?>
                    </select>
                  </div>
                </div>
            </div>
            <div class="chart-container">
              <canvas id="orderChart"></canvas>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="row">
      <div class="col-12">
        <div class="chart-card">
          <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
              <h5 class="chart-title mb-0">Daily Sales Overview</h5>
            </div>
            <div class="daily-chart-container">
              <canvas id="dailySalesChart"></canvas>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <script>
    // Monthly Sales Chart with Animations
    const ctx = document.getElementById('orderChart').getContext('2d');
    const monthlySales = <?php echo $monthlySalesJson; ?>;
    
    const orderChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: [
                'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
            ],
            datasets: [{
                label: 'Monthly Sales (Rs)',
                data: monthlySales,
                backgroundColor: function(context) {
                    const chart = context.chart;
                    const {ctx, chartArea} = chart;
                    if (!chartArea) {
                        return '#6366f1';
                    }
                    const gradient = ctx.createLinearGradient(0, chartArea.bottom, 0, chartArea.top);
                    gradient.addColorStop(0, '#6366f1');
                    gradient.addColorStop(1, '#8b5cf6');
                    return gradient;
                },
                borderRadius: 8,
                borderSkipped: false,
                barThickness: 30,
                hoverBackgroundColor: '#4f46e5',
                hoverBorderRadius: 10
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            animation: {
                duration: 1500,
                easing: 'easeInOutQuart',
                delay: function(context) {
                    return context.dataIndex * 100;
                }
            },
            hover: {
                animationDuration: 200
            },
            plugins: {
                title: {
                    display: true,
                    text: 'Monthly Sales - Year <?php echo $selectedYear; ?>',
                    font: {
                        size: 16,
                        weight: 'bold'
                    },
                    color: '#374151'
                },
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(17, 24, 39, 0.95)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: '#6366f1',
                    borderWidth: 1,
                    cornerRadius: 8,
                    displayColors: false,
                    callbacks: {
                        label: function(context) {
                            return 'Sales: Rs.' + context.parsed.y.toLocaleString();
                        }
                    }
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        color: '#6b7280',
                        font: {
                            weight: '500'
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(229, 231, 235, 0.5)',
                        drawBorder: false
                    },
                    ticks: {
                        color: '#6b7280',
                        callback: function(value) {
                            return 'Rs.' + value.toLocaleString();
                        }
                    }
                }
            },
            interaction: {
                mode: 'index',
                intersect: false
            }
        }
    });
    
    function updateChart(selectedYear) {
    // Show loading indicator (optional)
        const chartContainer = document.querySelector('.chart-container');
        chartContainer.style.opacity = '0.5';
        
        // Make AJAX request
        fetch('get_monthly_data.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: 'year=' + encodeURIComponent(selectedYear)
        })
        .then(response => response.json())
        .then(data => {
            // Update the chart with new data
            orderChart.data.datasets[0].data = data.monthlySales;
            orderChart.options.plugins.title.text = 'Monthly Sales - Year ' + selectedYear;
            orderChart.update('active');
            
            // Remove loading indicator
            chartContainer.style.opacity = '1';
        })
        .catch(error => {
            console.error('Error:', error);
            chartContainer.style.opacity = '1';
            alert('Error loading chart data. Please try again.');
        });
    }
    
    // Daily Sales Chart with Animations
    const dailyCtx = document.getElementById('dailySalesChart').getContext('2d');
    const dailyCurrent = <?php echo $dailyCurrentJson; ?>;
    const dailyPrevious = <?php echo $dailyPreviousJson; ?>;
    
    // Labels for max 31 days
    const dayLabels = Array.from({ length: 31 }, (_, i) => `${i + 1}`);
    
    const dailySalesChart = new Chart(dailyCtx, {
        type: 'line',
        data: {
            labels: dayLabels,
            datasets: [
                {
                    label: 'This Month',
                    data: dailyCurrent,
                    borderColor: '#6366f1',
                    backgroundColor: function(context) {
                        const chart = context.chart;
                        const {ctx, chartArea} = chart;
                        if (!chartArea) {
                            return 'rgba(99, 102, 241, 0.1)';
                        }
                        const gradient = ctx.createLinearGradient(0, chartArea.bottom, 0, chartArea.top);
                        gradient.addColorStop(0, 'rgba(99, 102, 241, 0.1)');
                        gradient.addColorStop(1, 'rgba(99, 102, 241, 0.3)');
                        return gradient;
                    },
                    fill: true,
                    tension: 0.4,
                    pointRadius: 4,
                    pointHoverRadius: 8,
                    pointBackgroundColor: '#6366f1',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointHoverBackgroundColor: '#4f46e5',
                    pointHoverBorderColor: '#fff',
                    pointHoverBorderWidth: 3,
                    borderWidth: 3
                },
                {
                    label: 'Last Month',
                    data: dailyPrevious,
                    borderColor: '#f97316',
                    backgroundColor: function(context) {
                        const chart = context.chart;
                        const {ctx, chartArea} = chart;
                        if (!chartArea) {
                            return 'rgba(249, 115, 22, 0.1)';
                        }
                        const gradient = ctx.createLinearGradient(0, chartArea.bottom, 0, chartArea.top);
                        gradient.addColorStop(0, 'rgba(249, 115, 22, 0.1)');
                        gradient.addColorStop(1, 'rgba(249, 115, 22, 0.3)');
                        return gradient;
                    },
                    fill: true,
                    tension: 0.4,
                    pointRadius: 4,
                    pointHoverRadius: 8,
                    pointBackgroundColor: '#f97316',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointHoverBackgroundColor: '#ea580c',
                    pointHoverBorderColor: '#fff',
                    pointHoverBorderWidth: 3,
                    borderWidth: 3
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            animation: {
                duration: 2000,
                easing: 'easeInOutQuart',
                x: {
                    type: 'number',
                    easing: 'linear',
                    duration: 1500,
                    from: NaN,
                    delay: function(ctx) {
                        return ctx.type === 'data' && ctx.mode === 'default' ? ctx.dataIndex * 50 : 0;
                    }
                },
                y: {
                    type: 'number',
                    easing: 'easeInOutQuart',
                    duration: 1500,
                    from: function(ctx) {
                        const chart = ctx.chart;
                        const yScale = chart.scales.y;
                        return yScale.getPixelForValue(0);
                    }
                }
            },
            hover: {
                animationDuration: 200,
                intersect: false
            },
            plugins: {
                title: {
                    display: true,
                    text: 'Daily Sales Comparison - <?php echo date("F Y", strtotime($currentMonthStart)); ?> vs <?php echo date("F Y", strtotime($previousMonthStart)); ?>',
                    font: {
                        size: 16,
                        weight: 'bold'
                    },
                    color: '#374151'
                },
                legend: {
                    position: 'top',
                    labels: {
                        usePointStyle: true,
                        pointStyle: 'circle',
                        font: {
                            weight: '500'
                        },
                        color: '#374151'
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(17, 24, 39, 0.95)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: '#6366f1',
                    borderWidth: 1,
                    cornerRadius: 8,
                    displayColors: true,
                    callbacks: {
                        label: function(context) {
                            return context.dataset.label + ': Rs.' + context.parsed.y.toLocaleString();
                        }
                    }
                }
            },
            scales: {
                x: {
                    grid: {
                        color: 'rgba(229, 231, 235, 0.3)',
                        drawBorder: false
                    },
                    ticks: {
                        color: '#6b7280',
                        font: {
                            weight: '500'
                        }
                    },
                    title: {
                        display: true,
                        text: 'Day of Month',
                        color: '#374151',
                        font: {
                            weight: '600'
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(229, 231, 235, 0.5)',
                        drawBorder: false
                    },
                    ticks: {
                        color: '#6b7280',
                        callback: function(value) {
                            return 'Rs.' + value.toLocaleString();
                        }
                    },
                    title: {
                        display: true,
                        text: 'Sales Amount (Rs.)',
                        color: '#374151',
                        font: {
                            weight: '600'
                        }
                    }
                }
            },
            interaction: {
                mode: 'index',
                intersect: false
            },
            elements: {
                point: {
                    hoverBorderWidth: 3
                }
            }
        }
    });
    
</script>

</body>
</html>